%This script tests the set/get methods.
function test_suite = testSetGet %#ok<*STOUT>
initTestSuite;

function obj = setup
obj = BertiniLab; % Set up with default fields

function testConfig(obj) %#ok<*DEFNU>
obj.config = struct('TRACKTYPE',1);
assert(isfield(obj.config,'TRACKTYPE'))
assertEqual(obj.config.TRACKTYPE,1)

function testConfigNotStruct(~)
f = @() BertiniLab('config','TRACKTYPE');
assertExceptionThrown(f,'MATLAB:set:config:invalidType')

function testInvalidField(~)
f = @() BertiniLab('var',polysym('x'));
assertExceptionThrown(f,'MATLAB:noPublicFieldForClass')

% ------------- variable -------------- 
function testVariablePolysym(obj)
polysyms x
obj.variable = x;
assertEqual(obj.variable,x)

function testVariableSym(obj)
syms x
obj.variable = x;
assertEqual(obj.variable,polysym('x'))

function testVariableString(obj)
obj.variable = 'x';
assertEqual(obj.variable,polysym('x'))

function testVariableMatrix(obj)
v = polysym('v',2);
obj.variable = v;
assertEqual(obj.variable,v)

function testVariableEmptyStruct(obj)
obj.variable = [];
assertEqual(obj.variable,polysym.empty)

function testVariableInvalidType(~)
f = @() BertiniLab('variable',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

function testVariableMultihomogeneous(~)
polysyms('x','y')
f = @() BertiniLab('variable',{x,y});
assertExceptionThrown(f,'BertiniLab:set:variable:invalidType')

% ------------- variable_group -------------- 
function testVariableGroupPolysym(obj)
polysyms x
obj.variable_group = x;
assertEqual(obj.variable_group,x)

function testVariableGroupSym(obj)
syms x
obj.variable_group = x;
assertEqual(obj.variable_group,polysym('x'))

function testVariableGroupString(obj)
obj.variable_group = 'x';
assertEqual(obj.variable_group,polysym('x'))

function testVariableGroupMatrix(obj)
v = polysym('v',2);
obj.variable_group = v;
assertEqual(obj.variable_group,v)

function testVariableGroupEmptyStruct(obj)
obj.variable_group = [];
assertEqual(obj.variable_group,polysym.empty)

function testVariableGroupInvalidType(~)
f = @() BertiniLab('variable_group',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

function testVariableGroupMultihomogeneous(obj)
polysyms('x','y')
obj.variable_group = {x, y};
assertEqual(obj.variable_group,{x,y})

% ------------- hom_variable_group -------------- 
function testHomVariableGroupPolysym(obj)
polysyms x
obj.hom_variable_group = x;
assertEqual(obj.hom_variable_group,x)

function testHomVariableGroupSym(obj)
syms x
obj.hom_variable_group = x;
assertEqual(obj.hom_variable_group,polysym('x'))

function testHomVariableGroupString(obj)
obj.hom_variable_group = 'x';
assertEqual(obj.hom_variable_group,polysym('x'))

function testHomVariableGroupMatrix(obj)
v = polysym('v',2);
obj.hom_variable_group = v;
assertEqual(obj.hom_variable_group,v)

function testHomVariableGroupEmptyStruct(obj)
obj.hom_variable_group = [];
assertEqual(obj.hom_variable_group,polysym.empty)

function testHomVariableGroupInvalidType(~)
f = @() BertiniLab('hom_variable_group',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

function testHomVariableGroupMultihomogeneous(obj)
polysyms('x','y')
obj.hom_variable_group = {x, y};
assertEqual(obj.hom_variable_group,{x,y})

% ------------- constant -------------- 
function testConstantPolysym(obj)
obj.constant = polysym({'x','0'});
assertEqual(obj.constant,polysym({'x','0'}))

function testConstantSym(obj)
obj.constant = [sym('x') sym(0)];
assertEqual(obj.constant,polysym({'x',char(vpa(0))}))

function testConstantString(obj)
obj.constant = {'x',0};
assertEqual(obj.constant,polysym({'x','0'}))

function testConstantWrongSize(~)
f = @() BertiniLab('constant',polysym('x'));
assertExceptionThrown(f,'MATLAB:set:constant:incorrectNumcols')

function testNonEmptyThenEmpty(obj)
obj.constant = {'x',0};
obj.constant = [];
assertEqual(obj.constant,polysym.empty(0,2))

% ------------- function_def -------------- 
function testFunctionDefsOneColumn(obj)
fnames = polysym('eqn',[4 1]);
fvals = polysym('x',[4 1]);
obj.function_def = fvals;
assertEqual(obj.function_def,fvals)
assertEqual(obj.function_name,fnames)

function testFunctionDefsWithName(obj)
obj.function_name = polysym('x');
obj.function_def = polysym('0');
assertEqual(obj.function_name,polysym('x'))
assertEqual(obj.function_def,polysym('0'))

function testFunctionDefsInvalidType(~)
f = @() BertiniLab('function_def',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

%-------------- Random --------------------
function testRandomPolysym(obj)
polysyms x
obj.random = x;
assertEqual(obj.random,x)

function testRandomSym(obj)
syms x
obj.random = x;
assertEqual(obj.random,polysym('x'))

function testRandomString(obj)
obj.random = 'x';
assertEqual(obj.random,polysym('x'))

function testRandomMatrix(~)
f = @() BertiniLab('random',polysym('v',2));
assertExceptionThrown(f,'MATLAB:set:random:expectedVector')

function testRandomEmpty(~)
f = @() BertiniLab('random',[]);
assertExceptionThrown(f,'MATLAB:set:random:expectedVector')

function testRandomInvalidType(~)
f = @() BertiniLab('random',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

%-------------- Random_real --------------------
function testRandomRealPolysym(obj)
polysyms x
obj.random_real = x;
assertEqual(obj.random_real,x)

function testRandomRealSym(obj)
syms x
obj.random_real = x;
assertEqual(obj.random_real,polysym('x'))

function testRandomRealString(obj)
obj.random_real = 'x';
assertEqual(obj.random_real,polysym('x'))

function testRandomRealMatrix(~)
f = @() BertiniLab('random_real',polysym('v',2));
assertExceptionThrown(f,'MATLAB:set:random_real:expectedVector')

function testRandomRealEmpty(~)
f = @() BertiniLab('random_real',[]);
assertExceptionThrown(f,'MATLAB:set:random_real:expectedVector')

function testRandomRealInvalidType(~)
f = @() BertiniLab('random_real',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

%-------------- definedSubfunction --------------------

function testDefinedSubfunctionPolysym(obj)
polysyms x
obj.definedSubfunction = x;
assertEqual(obj.definedSubfunction,x)

function testDefinedSubfunctionSym(obj)
syms x
obj.definedSubfunction = x;
assertEqual(obj.definedSubfunction,polysym('x'))

function testDefinedSubfunctionString(obj)
obj.definedSubfunction = 'x';
assertEqual(obj.definedSubfunction,polysym('x'))

function testDefinedSubfunctionVector(~)
f = @() BertiniLab('definedSubfunction',polysym('x',[1 2]));
assertExceptionThrown(f,'MATLAB:set:definedSubfunction:expectedScalar')

function testDefinedSubfunctionEmpty(~)
f = @() BertiniLab('definedSubfunction',[]);
assertExceptionThrown(f,'MATLAB:set:definedSubfunction:expectedScalar')

function testDefinedSubfunctionInvalidType(~)
f = @() BertiniLab('definedSubfunction',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

function testDefinedSubfunctionNoFile(~)
f = @() BertiniLab('definedSubfunction',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

% ------------- starting_points -------------- 
function testStarting_pointsPolysym(obj)
polysyms x
obj.variable_group = x;
obj.starting_points = x;
assertEqual(obj.starting_points,x)

function testStarting_pointsSym(obj)
syms x
obj.variable_group = x;
obj.starting_points = x;
assertEqual(obj.starting_points,polysym('x'))

function testStarting_pointsString(obj)
obj.variable_group = 'x';
obj.starting_points = 'x';
assertEqual(obj.starting_points,polysym('x'))

function testStarting_pointsMatrix(obj)
v = polysym('v',2);
obj.variable_group = {'v1','v2'};
obj.starting_points = v;
assertEqual(obj.starting_points,v)

function testStarting_pointsEmpty(~)
f = @() BertiniLab('variable_group','x','starting_points',[]);
assertExceptionThrown(f,'BertiniLab:struct2mat:wrongLength')

function testStarting_pointsStruct(~)
f = @() BertiniLab('variable_group','x','starting_points',struct);
assertExceptionThrown(f,'BertiniLab:struct2mat:mismatched')

function testStarting_pointsMultihomogeneous(~)
polysyms('x','y')
obj = BertiniLab('variable_group',[x y],'starting_points',{0,1});
assertEqual(obj.starting_points,polysym([0; 1]))

% ------------- final_parameters -------------- 
function testFinal_parametersPolysym(obj)
polysyms x
obj.final_parameters = x;
assertEqual(obj.final_parameters,x)

function testFinal_parametersSym(obj)
syms x
obj.final_parameters = x;
assertEqual(obj.final_parameters,polysym('x'))

function testFinal_parametersString(obj)
obj.final_parameters = 'x';
assertEqual(obj.final_parameters,polysym('x'))

function testFinal_parametersMatrix(obj)
v = polysym('v',2);
obj.final_parameters = v;
assertEqual(obj.final_parameters,v)

function testFinal_parametersEmptyStruct(obj)
obj.final_parameters = [];
assertEqual(obj.final_parameters,polysym.empty)

function testFinal_parametersInvalidType(~)
f = @() BertiniLab('final_parameters',struct);
assertExceptionThrown(f,'MATLAB:polysym:invalidType')

% ------------- Output_file_names -------------- 
function testNoSummary(obj)
assertTrue(isempty(obj.output_file_names))

function testSummary1(~)
poly_system = BertiniLab('function_def',{'x^2-1'; 'y^2-4'},'variable_group',{'x','y'});
poly_system = solve(poly_system);
fnames = {'main_data','raw_solutions','raw_data','real_finite_solutions', ...
    'finite_solutions','nonsingular_solutions','singular_solutions'};
assertEqual(poly_system.output_file_names,fnames)

% ------------- Protected properties -------------- 
function testTryToSetSolveSummary(obj) %#ok<INUSD>
f = @() eval('obj.solve_summary=rand');
assertExceptionThrown(f,'MATLAB:class:SetProhibited')

